*                                                                                  ;
 *    Reading in the 1969 PSID data                                                 ;
 *                                                                                  ;
 *            Karen Dynan 8/26/06                                                   ;
 *                                                                                  ;
 *    We read it all in and then output select variables to a flat                  ;
 *    file to be picked up by STATA.                                                ;
 *                                                                                  ;
 
libname psid 'F:\PSID' ;
filename rawdat 'F:\PSID\raw\fam69.raw' ;
 
 data one;
 
   infile 'F:\PSID\69FAM.DAT'  lrecl=1043 missover;
   INPUT
   V441 1-3               V442 4-7               V443 8-11
   V444 12                V445 13-15             V446 16
   V447 17-19             V448 20                V449 21-25
   V450 26                V451 27-31             V452 32
   V453 33-36             V454 37                V455 38-41
   V456 42                V457 43-46             V458 47
   V459 48                V460 49-52             V461 53
   V462 54-57             V463 58                V464 59-62
   V465 63-66             V466 67                V467 68-71
   V468 72                V469 73-76             V470 77
   V471 78-81             V472 82                V473 83-85
   V474 86                V475 87-90             V476 91
   V477 92-95             V478 96                V479 97-99
   V480 100               V481 101-104           V482 105
   V483 106-109           V484 110               V485 111-114
   V486 115               V487 116-119           V488 120
   V489 121-124           V490 125               V491 126-129
   V492 130               V493 131-132           V494 133-136
   V495 137-141           V496 142-145           V497 146
   V498 147-149           V499 150               V500 151-154
   V501 155               V502 156-159           V503 160
   V504 161-164           V505 165               V506 166-169
   V507 170               V508 171-174           V509 175
   V510 176-179           V511 180               V512 181-184
   V513 185               V514 186-190           V515 191
   V516 192-196           V517 197               V518 198-202
   V519 203               V520 204-207           V521 208-212
   V522 213               V523 214-218           V524 219
   V525 220-224           V526 225               V527 226-230
   V528 231               V529 232-236           V530 237-240
   V531 241               V532 242-246           V533 247-251
   V534 252-255           V535 256               V536 257-259
   V537 260-261           V538 262-266           V539 267
   V540 268               V541 269               V542 270
   V543 271               V544 272               V545 273
   V546 274               V547 275               V548 276
   V549 277-278           V550 279-280           V551 281-289
   V552 290-291           V553 292               V554 293-295
   V555 296               V556 297               V557 298
   V558 299               V559 300               V560 301
   V561 302               V562 303-304           V563 305-306
   V564 307-308           V565 309-310           V566 311
   V567 312               V568 313               V569 314
   V570 315               V571 316               V572 317
   V573 318               V574 319               V575 320
   V576 321               V577 322               V578 323
   V579 324               V580 325               V581 326
   V582 327-328           V583 329               V584 330
   V585 331               V586 332               V587 333
   V588 334               V589 335               V590 336
   V591 337               V592 338               V593 339
   V594 340               V595 341               V596 342
   V597 343               V598 344               V599 345
   V600 346               V601 347               V602 348
   V603 349               V604 350               V605 351
   V606 352               V607 353               V608 354
   V609 355               V610 356               V611 357
   V612 358               V613 359               V614 360
   V615 361               V616 362               V617 363
   V618 364               V619 365               V620 366
   V621 367               V622 368               V623 369
   V624 370               V625 371               V626 372
   V627 373               V628 374               V629 375
   V630 376               V631 377               V632 378
   V633 379               V634 380               V635 381
   V636 382               V637 383               V638 384
   V639 385               V640 386               V641 387
   V642 388               V643 389               V644 390
   V645 391               V646 392               V647 393-395
   V648 396               V649 397               V650 398
   V651 399               V652 400               V653 401
   V654 402               V655 403               V656 404
   V657 405               V658 406               V659 407
   V660 408               V661 409               V662 410
   V663 411-413           V664 414               V665 415
   V666 416               V667 417-419           V668 420
   V669 421               V670 422               V671 423
   V672 424               V673 425               V674 426-427
   V675 428               V676 429               V677 430
   V678 431               V679 432               V680 433
   V681 434               V682 435-437           V683 438
   V684 439               V685 440               V686 441
   V687 442-444           V688 445               V689 446-448
   V690 449               V691 450               V692 451
   V693 452               V694 453               V695 454
   V696 455               V697 456               V698 457
   V699 458               V700 459               V701 460
   V702 461               V703 462               V704 463
   V705 464               V706 465               V707 466
   V708 467               V709 468               V710 469
   V711 470               V712 471               V713 472
   V714 473               V715 474               V716 475
   V717 476               V718 477               V719 478
   V720 479               V721 480               V722 481
   V723 482               V724 483               V725 484
   V726 485               V727 486               V728 487
   V729 488               V730 489               V731 490
   V732 491               V733 492               V734 493
   V735 494               V736 495               V737 496
   V738 497               V739 498               V740 499
   V741 500               V742 501               V743 502
   V744 503               V745 504               V746 505
   V747 506               V748 507               V749 508
   V750 509               V751 510               V752 511
   V753 512               V754 513               V755 514
   V756 515               V757 516               V758 517
   V759 518               V760 519               V761 520
   V762 521               V763 522               V764 523
   V765 524               V766 525               V767 526
   V768 527               V769 528               V770 529
   V771 530               V772 531               V773 532
   V774 533               V775 534               V776 535
   V777 536               V778 537               V779 538
   V780 539               V781 540               V782 541
   V783 542               V784 543               V785 544
   V786 545               V787 546-547           V788 548-552
   V789 553               V790 554               V791 555
   V792 556               V793 557               V794 558
   V795 559               V796 560               V797 561
   V798 562               V799 563               V800 564
   V801 565               V802 566               V803 567
   V804 568               V805 569               V806 570
   V807 571               V808 572-574           V809 575
   V810 576               V811 577               V812 578
   V813 579               V814 580               V815 581
   V816 582               V817 583               V818 584
   V819_1 585             V819_2 586             V820_1 587
   V820_2 588             V821_1 589             V821_2 590
   V822 591-594           V823 595-598           V824 599
   V825 600-603           V826 604-607           V827 608
   V828 609               V829 610               V830 611
   V831 612               V832 613               V833 614
   V834 615               V835 616-619 .2        V836 620
   V837 621-623           V838 624               V839 625-628
   V840 629-633           V841 634               V842 635-639
   V843 640               V844 641-644 .2        V845 645
   V846 646-648           V847 649               V848 650-653
   V849 654               V850 655-659           V851 660
   V852 661-664 .2        V853 665               V854 666-668
   V855 669               V856 670-674           V857 675
   V858 676-679 .2        V859 680               V860 681-683
   V861 684               V862 685-687           V863 688-691
   V864 692               V865 693-696 .2        V866 697
   V867 698-701           V868 702               V869 703-706
   V870 707               V871 708-711 .2        V872 712
   V873 713-716 .2        V874 717               V875 718
   V876 719               V877 720               V878 721
   V879 722               V880 723               V881 724
   V882 725-726           V883 727-728           V884 729-733
   V885 734               V886 735               V887 736
   V888 737               V889 738               V890 739
   V891 740               V892 741-742 .1        V893 743
   V894 744-745           V895 746-749           V896 750
   V897 751               V898 752               V899 753
   V900 754               V901 755               V902 756
   V903 757               V904 758               V905 759
   V906 760               V907 761-764           V908 765-768
   V909 769               V910 770-774           V911 775-778
   V912 779               V913 780               V914 781-785
   V915 786-790           V916 791-794           V917 795-799
   V918 800-804           V919 805-809           V920 810-813
   V921 814               V922 815               V923 816-819 .2
   V924 820-823           V925 824               V926 825
   V927 826-828           V928 829-832           V929 833
   V930 834               V931 835-839           V932 840-844
   V933 845-848           V934 849-852 .2        V935 853-856
   V936 857-859           V937 860-863           V938 864-868
   V939 869-872           V940 873-876           V941 877-880
   V942 881-885           V943 886-889           V944 890
   V945 891-895           V946 896-900           V947 901-905
   V948 906-910           V949 911-915           V950 916-920
   V951 921-925           V952 926-929           V953 930-933 .2
   V954 934-937           V955 938               V956 939-942 .2
   V957 943-947           V958 948-951           V959 952-956
   V960 957-961           V961 962-965           V962 966-969 .2
   V963 970-973           V964 974-977           V965 978-981
   V966 982               V967 983               V968 984
   V969 985               V970 986               V971 987
   V972 988               V973 989               V974 990
   V975 991               V976 992-993           V977 994
   V978 995               V979 996               V980 997
   V981 998               V982 999               V983 1000
   V984 1001              V985 1002              V986 1003
   V987 1004              V988 1005              V989 1006-1010 .2
   V990 1011              V991 1012              V992 1013
   V993 1014              V994 1015              V995 1016
   V996 1017              V997 1018              V998 1019
   V999 1020              V1000 1021             V1001 1022
   V1002 1023             V1003 1024             V1004 1025
   V1005 1026             V1006 1027             V1007 1028
   V1008 1029-1030        V1009 1031             V1010 1032
   V1011 1033-1034        V1012 1035             V1013 1036
   V1014 1037-1038        V1015 1039-1042        V1016 1043;

* SAS LABEL STATEMENT;

LABEL
   V441 = "STUDY 768 1969(WAVE 2)"
   V442 = "1969 INT NUMBER   11:6-9"
   V443 = "VALUE OF CARS   11:10-13"
   V444 = "ACCURACY CAR VALUE 11:14"
   V445 = "SAVED CAR REPAIR11:15-17"
   V446 = "ACCRCY OF SAVD CAR 11:18"
   V447 = "HOURS OF CAR REP11:19-21"
   V448 = "ACCRCY HRS. C.REP. 11:22"
   V449 = "HOUSE VALUE     11:23-27"
   V450 = "ACCRCY HOUSE VALUE 11:28"
   V451 = "REM MORTG PRIN  11:29-33"
   V452 = "ACCRCY REM MORTG PR11:34"
   V453 = "ANNUAL MORTG PAY11:35-38"
   V454 = "ACCRCY MORTG PAYTS 11:39"
   V455 = "ANNUAL RENT PYTS11:40-43"
   V456 = "ACCRCY RENT PAYTS  11:44"
   V457 = "ANNUAL RENT VAL 11:45-48"
   V458 = "ACCRCY RENT VALUE  11:49"
   V459 = "CODE:WORK FOR HOUSE11:50"
   V460 = "ANNUAL UTIL PYTS11:51-54"
   V461 = "ACCRCY UTIL PYTS   11:55"
   V462 = "$  SAV ADD + REP 11:56-59"
   V463 = "ACCRCY $ SAV ADD+REP11:60"
   V464 = "HOME PROD HRS (REV) 9V24"
   V465 = "HRS HEAD WORKED 12:10-13"
   V466 = "ACCRCY HRS HD WRK  12:14"
   V467 = "HRS HEAD ILL    12:15-18"
   V468 = "ACCRCY HRS HD ILL  12:19"
   V469 = "HRS HD UNEMPLD  12:20-23"
   V470 = "ACCRCY HRS UNEMPLD 12:24"
   V471 = "$  HEAD TRVL WRK 12:25-28"
   V472 = "ACCRCY $  HEAD TRVL 12:29"
   V473 = "HRS HD TRVL WRK 12:30-32"
   V474 = "ACCRCY HRS HD TRVL 12:33"
   V475 = "HRS WIFE WORKED 12:34-37"
   V476 = "ACCRCY HRS WIFE WRK12:38"
   V477 = "$  WIFE TRVL WRK 12:39-42"
   V478 = "ACCRCY $  WIFE TRVL 12:43"
   V479 = "HRS WF TRVL WRK 12:44-46"
   V480 = "ACCRCY HRS WF TRVL 12:47"
   V481 = "HRS HSWRK 1ST.  12:48-51"
   V482 = "ACCRCY HSWRK 1ST   12:52"
   V483 = "HRS.HSWK HUSBND 12:53-56"
   V484 = "ACCRCY HSWK HUSB   12:57"
   V485 = "HRS HSWRK OTHRS 12:58-61"
   V486 = "ACCRCY HSWRK OTHRS 12:62"
   V487 = "HRS HSWRK NONFU 12:63-66"
   V488 = "ACCRCY HRS         12:67"
   V489 = "$  HSWRK NONFU   12:68-71"
   V490 = "ACCRCY $  HSK NONFU 12:72"
   V491 = "TOT NONLEISUR (REV) 9V51"
   V492 = "# MAJOR ADULTS     12:77"
   V493 = "# IN FAMILY (69)13:10-11"
   V494 = "FU FOOD STANDRD 13:12:15"
   V495 = "FU NEED STANDRD 13:16-20"
   V496 = "$  ANN ALCHL EXP 13:21-24"
   V497 = "ACCRCY $  ANN ALCHL 13:25"
   V498 = "$  ANN CIG EXPND 13:26-28"
   V499 = "ACCRCY $  ANN CIG   13:29"
   V500 = "$  FOOD USD HOME 13:30-33"
   V501 = "ACCRCY $  FOOD HOME 13:34"
   V502 = "$  MEALS WRK/SCH 13:35-38"
   V503 = "ACCRCY $  MEALS W/S 13:39"
   V504 = "$  SAVD MEALS W/S13:40-43"
   V505 = "ACCRCY $  SAVD MEALS13:44"
   V506 = "$  EATING OUT    13:45-48"
   V507 = "ACCRCY $  EATING OUT13:49"
   V508 = "$ SAVD GROW FOOD 13:50-53"
   V509 = "ACCRCY $  SAVD GR FD13:54"
   V510 = "$ SAVD FOOD STMP 13:55-58"
   V511 = "ACCRCY $ SVD FD STMP13:59"
   V512 = "$ SVD FREE FOOD  13:60-63"
   V513 = "ACCRCY $ SVD FREE FD13:64"
   V514 = "LABOR INC HEAD  14:10-14"
   V515 = "ACCRCY LBR INC HD  14:15"
   V516 = "LABOR INC WIFE  14:16-20"
   V517 = "ACCRCY LBR INC WF  14:21"
   V518 = "H+W TAXABLE INC 14:22-26"
   V519 = "ACCRCY H+W TXB INC 14:27"
   V520 = "HOURS WRK OTHRS 14:28-31"
   V521 = "TAXBL INC OTHRS 14:32-36"
   V522 = "ACCRCY TXBL INC OTH14:37"
   V523 = "ADC,AFDC HEAD+W 14:38-42"
   V524 = "ACCRCY ADC INCOME  14:43"
   V525 = "MISC TRANSFERS  14:44-48"
   V526 = "ACCRCY MISC TRNSFR 14:49"
   V527 = "TRNSFR INC OTHRS14:50-54"
   V528 = "ACCRCY TR INC OTHR 14:55"
   V529 = "TOTAL FU $  INC  14:56-60"
   V530 = "$  CNTRB OUT FU  14:61-64"
   V531 = "ACCRCY $  CNTRB OUT 14:65"
   V532 = "FU FED INC TAX  14:66-70"
   V533 = "FU COST OF INC  14:71-75"
   V534 = "68 IW NUMBER    15:10-13"
   V535 = "PSU-HUNDREDS DIGIT 15:14"
   V536 = "PSU ORIG SRC/CPS15:14-16"
   V537 = "STATE NOW       15:17-18"
   V538 = "STATE,COUNTY NOW15:17-21"
   V539 = "LRGST PLAC/SMSA PSU15:22"
   V540 = "PLACE-SRC,FU#-CENS 15:23"
   V541 = "QUALITY OF MATCH   15:24"
   V542 = "CHANGE IN FU COMP  15:25"
   V543 = "# MOVED INTO FU    15:26"
   V544 = "REL-HEAD:MOVER IN  15:27"
   V545 = "# MOVED OUT OF FU  15:28"
   V546 = "REL-HEAD:MOVER OUT 15:29"
   V547 = "69 FU COMPOSITION  15:30"
   V548 = "WHETHER TELEPHONE  15:31"
   V549 = "TOTAL # IN FU   15:32-33"
   V550 = "# CHILDRN IN FU 15:34-35"
   V551 = "IWERS SOC SEC # 15:36-44"
   V552 = "IWERS INT #     15:45-46"
   V553 = "DATE OF IW      1  15:47"
   V554 = "LNGTH OF IW     15:48-50"
   V555 = "ANY CHILD UNDER 25 15:51"
   V556 = "NR CHLDRN IN SCHOOL15:52"
   V557 = "EDUC EXPT CHILDREN 15:53"
   V558 = "LAST PTA MTG ATTND 15:54"
   V559 = "ANY CHILD STOP SCH 15:55"
   V560 = "HGST GRADE DROP-OUT15:56"
   V561 = "NR CHLDRN LVNG AWAY15:57"
   V562 = "AGE OLDST CHILD 15:58-59"
   V563 = "AGE 2ND OLDEST  15:60-61"
   V564 = "AGE 3RD OLDEST  15:62-63"
   V565 = "NR CHLDRN HEAD  15:64-65"
   V566 = "NR CHLDRN HD BY25  15:66"
   V567 = "NR SIBLINGS HEAD   15:67"
   V568 = "HD ANY LIVNG BRTHR 15:68"
   V569 = "AGE OLDST BROTH15:69"
   V570 = "ED OLDST LIVNG BROTH15:7"
   V571 = "OLDST BROTH WELLOFF15:71"
   V572 = "HD ANY LIVNG SIST15:72"
   V573 = "AGE OLDST LVNG SIST15:73"
   V574 = "ED OLDST LVNG SIST15:74"
   V575 = "OLDST SIST WELL OFF15:75"
   V576 = "PUBLIC TRANSP AVAIL16:10"
   V577 = "PUB TRANSP GOOD    16:11"
   V578 = "OWN A CAR OR TRUCK 16:12"
   V579 = "DIFFIC FR NO CAR   16:13"
   V580 = "WHAT DIFFIC NO CAR 16:14"
   V581 = "NR CARS OWNED      16:15"
   V582 = "YR OF NEWST CAR 16:16-17"
   V583 = "CONDIT NEWEST CAR  16:18"
   V584 = "ALL CARS INSURED?  16:19"
   V585 = "CAR HAVE SEAT BELTS16:20"
   V586 = "SEAT BELTS FASTND  16:21"
   V587 = "DID OWN CAR REPAIR 16:22"
   V588 = "KINDS OF CAR REPAIR16-23"
   V589 = "SAVD CAR REPR BKT  16-24"
   V590 = "TIME ON CAR REPAIR 16-25"
   V591 = "REQUIRED NR ROOMS  16-26"
   V592 = "ACTUAL NR ROOMS    16:27"
   V593 = "OWN OR RENT?       16-28"
   V594 = "MORTGAGE?          16-29"
   V595 = "SECOND MORTGAGE?   16-30"
   V596 = "WHY FREE HOUSING   16:31"
   V597 = "WORK DONE ON HOUSE 16-32"
   V598 = "WHAT A+R DONE?     16-33"
   V599 = "A+R DONE SELF      16-34"
   V600 = "WHAT A+R DONE SELF 16-35"
   V601 = "NR NEIGHBORS KNOWN 16-36"
   V602 = "RELATIVES NEAR?    16:37"
   V603 = "MOVED SINCE SPRNG6816-38"
   V604 = "WHY MOVED          16-39"
   V605 = "MIGHT MOVE         16-40"
   V606 = "WHY MIGHT MOVE     16-41"
   V607 = "MARITAL STATUS     16:42"
   V608 = "DID WIFE WORK      16-43"
   V609 = "OCCUPATION-WIFE    16-44"
   V610 = "WEEKS WIFE WRK BKT 16-45"
   V611 = "HRS/WEEK WIFE BKT  16:46"
   V612 = "WIFE UNDER 45      16-47"
   V613 = "EXPECT CHILDREN?   16-48"
   V614 = "WHEN EXPCT CHILD   16-49"
   V615 = "HOW SURE NO CHLDRN 16-50"
   V616 = "WHO DOES HOUSEWORK 16-51"
   V617 = "HRS/WK MAIN HOUSWKR16:52"
   V618 = "OTHERS DO HOUSEWRK 16-53"
   V619 = "HELP FROM OUTSIDE? 16-54"
   V620 = "PAY FOR HELP?      16-55"
   V621 = "$ /WK HOME FOOD BKT 16:56"
   V622 = "FOOD DELIVRD ALSO  16-57"
   V623 = "$ /WK DELIVRD FD BKT16:58"
   V624 = "$ /WK ALCOHOL BKT   16:59"
   V625 = "ALCOH IN FOOD BILL 16-60"
   V626 = "ANY SMOKERS        16-61"
   V627 = "NR CIGS SMOKED     16-62"
   V628 = "CIGS IN FOOD BILL  16-63"
   V629 = "MEALS AT WK OR SCH 16-64"
   V630 = "$ /WK MEALS W+S BKT 16:65"
   V631 = "ANY FREE MEALS W+S 16-66"
   V632 = "$ /WK EATING OUT BKT16:67"
   V633 = "HOME FOOD PRODUCTN 16-68"
   V634 = "FOOD STAMPS?       16:69"
   V635 = "$ SVD/MO FD STMP BKT16:70"
   V636 = "PAY/MO FD STMPS BKT16:71"
   V637 = "OTHER FREE FOOD?   16:72"
   V638 = "HOW OFTN EAT TGTHR 16-73"
   V639 = "EMPLOYMENT STATUS  17:10"
   V640 = "OCCUPATION OF HEAD 17:11"
   V641 = "SELF-EMPLOYED HEAD 17:12"
   V642 = "HOW LONG HAD JOB   17:13"
   V643 = "HAPPEND PREV JOB   17:14"
   V644 = "JOB PAY MORE NOW   17:15"
   V645 = "PRESENT JOB BETTER 17:16"
   V646 = "WHY JOB BETTER     17:17"
   V647 = "PAY/HR SOUGHT(U)17:19-21"
   V648 = "TRAINING REQD(U)   17:22"
   V649 = "HOW FINDING JOB(U) 17:23"
   V650 = "NR PLACES LOOKED(U)17:24"
   V651 = "HAPPND PREC JOB(U) 17:25"
   V652 = "TOOK VACATION 68(E)17:26"
   V653 = "WKS VACATION BKT(E)17:27"
   V654 = "MISS WORK SICK (E) 17:28"
   V655 = "WKS SICK BKT (E)   17:29"
   V656 = "UNEMPLOYED? (E)    17:30"
   V657 = "WKS UNEMPLD BKT(E) 17:31"
   V658 = "WEEKS WORK HEAD BKT17:32"
   V659 = "HOURS/WK WRK HD BKT17:33"
   V660 = "EXTRA JOBS? (E)    17:34"
   V661 = "OCCUP XTRA JOB (E) 17:35"
   V662 = "MORE THAN 2 JOBS(E)17:36"
   V663 = "PAY/HR EXTR WRK 17:37-39"
   V664 = "WEEKS EXTRA JOB (E)17:40"
   V665 = "HRS/WK EXT JOB (E) 17:41"
   V666 = "MORE WRK AVAILABLE 17:42"
   V667 = "MARGINAL WAGE 17:43-45"
   V668 = "WANTED MORE WORK   17:46"
   V669 = "COULD WDRKED LESS  17:47"
   V670 = "PREFERD LESS WORK  17:48"
   V671 = "WKS SICK BKT (U)   17:49"
   V672 = "WKS UNEMPLD BKT(U) 17:50"
   V673 = "DRIVE TO WORK OR?  17:51"
   V674 = "MILES TO WORK   17:52-53"
   V675 = "PAY FOR PARKING    17:54"
   V676 = "LATE GETTNG TO WORK17:55"
   V677 = "HOW OFTEN LATE     17:56"
   V678 = "SKIP WORK-NOT SICK 17:57"
   V679 = "HOW OFTEN SKIP WORK17:58"
   V680 = "MAY GET NEW JOB(E) 17:59"
   V681 = "KIND OF NEW JOB(E) 17:60"
   V682 = "POSSIBLE WAGE(E)17:61-63"
   V683 = "TRNING NEW JOB?(E) 17:64"
   V684 = "DOING ABT NU JOB(E)17:65"
   V685 = "#PLACES APPLIED(R) 17:66"
   V686 = "JOBS NOT WORTH IT  17:67"
   V687 = "PAY/HR REJECTED 17:68-70"
   V688 = "WILLING TO MOVE JOB17:71"
   V689 = "PAY/HR REQD-MOVE17:72-74"
   V690 = "WHY WONT MOVE JOB  17:75"
   V691 = "CHOOSES WAY WORKS  17:76"
   V692 = "LIKE MORE CHOICE   17:77"
   V693 = "THINKING WRK FUT(R)17:78"
   V694 = "WORK DEPENDS ON(R) 17:79"
   V695 = "TOT FARM RECPTS BKT18:10"
   V696 = "OWN A BUSINESS     18:11"
   V697 = "BUS INCORPORATED   18:12"
   V698 = "UNINCORP BUS Y BKT 18:13"
   V699 = "WAGES OF HEAD (BKT)18:14"
   V700 = "BONUSES ALSO?      18:15"
   V701 = "PROF PRACTICE Y BKT18:16"
   V702 = "FARM+ROOMER Y BKT  18:17"
   V703 = "DIV,INT,ETC. BKT   18:18"
   V704 = "ADC AFDC BKT       18:19"
   V705 = "OTHER WELFARE BKT  18:20"
   V706 = "SOCIAL SECURITY BKT18:21"
   V707 = "PENSIONS ETC. BKT  18:22"
   V708 = "UNEMPLOYT COMP,W-C 18:23"
   V709 = "ALIMONY BKT        18:24"
   V710 = "HELP FROM RELS BKT 18:25"
   V711 = "OTHER INCOME BKT   18:26"
   V712 = "OTHER HELP?        18:27"
   V713 = "AMT OTHER HELP BKT 18:28"
   V714 = "WIFE HAD INCOME    18:29"
   V715 = "KIND OF INC WIFE   18:30"
   V716 = "WIFE INCOME BKT    18:31"
   V717 = "# OTHR INC RECEIVES18:32"
   V718 = "INSURANCE,INHERIT  18:33"
   V719 = "AMT SETTLEMENT BKT 18:34"
   V720 = "68 Y HIGHER OR 67? 18:35"
   V721 = "WHY INC DIFFERENT  18:36"
   V722 = "WHO CAUSD INC CHNG 18:37"
   V723 = "UNUSUAL EXPENSES   18:38"
   V724 = "WHY EXP UNUSUAL HI 18:39"
   V725 = "68 BETTER, OR 67?  18:40"
   V726 = "WHY 68/7 BETTER 1ST18:41"
   V727 = "WHY 68/7 BETTER 2ND18:42"
   V728 = "LOT OR LITTL BETTR 18:43"
   V729 = "NXT FEW YRS OUTLOOK18:44"
   V730 = "1ST REASON OUTLOOK 18:45"
   V731 = "2ND REASON OUTLOOK 18:46"
   V732 = "ANY OUTSIDE DEPS?  18:47"
   V733 = "NR OUTSIDE DEPS    18:48"
   V734 = "ANY DEP>HALF SUPPT 18:49"
   V735 = "NR DEP >HALF SUPPT 18:50"
   V736 = "WOULD HELP RELATVS 18:51"
   V737 = "ANY SAVINGS        18:52"
   V738 = "TWO MO INC SAVED?  18:53"
   V739 = "TWO MO INC SVD 5YRS18:54"
   V740 = "MEDICAL INSURANCE  18:55"
   V741 = "ENTIRE FAMILY INSD 18:56"
   V742 = "FREE MED CARE AVAIL18:57"
   V743 = "DISAB LIM KIND WRK 18:58"
   V744 = "DISAB LIM AMT WORK 18:59"
   V745 = "HEALTH LIM HSEWRK  18:60"
   V746 = "HOW LONG LIMITED   18:61"
   V747 = "HEALTH IMPROVING   18:62"
   V748 = "OTHERS DISABLED?   18:63"
   V749 = "WHO ELSE DISABLED  18:64"
   V750 = "AGE OF DISABLED    18:65"
   V751 = "WHY OTHR DISABLED  18:66"
   V752 = "OTHR REQ EXTR CARE 18:67"
   V753 = "WHO REQ EXTRA CARE 18:68"
   V754 = "AGE REQ EXTRA CARE 18:69"
   V755 = "WHY REQ EXTRA CARE 18:70"
   V756 = "WHAT DO SPARE TIME 19:10"
   V757 = "2ND  DO SPARE TIME 19:11"
   V758 = "NR THINGS DONE S-T 19:12"
   V759 = "COURSES OR LESSONS 19:13"
   V760 = "WHAT COURSES       19:14"
   V761 = "HRS OF TELEVISION  19:15"
   V762 = "HOW OFTN NEWSPAPER 19:16"
   V763 = "HOW OFTEN CHURCH   19:17"
   V764 = "HOW OFTEN CLUBS    19:18"
   V765 = "HOW OFTEN BAR+TAVRN19:19"
   V766 = "UNION MEMBER       19:20"
   V767 = "AMT UNION DUES BKT 19:21"
   V768 = "PLANS TO MAKE DIFF 19:22"
   V769 = "WHAT PLANS FOR FUT 19:23"
   V770 = "SURE LIFE WORK OUT 19:24"
   V771 = "PLAN OR LIVE DAY-DY19:25"
   V772 = "CARRY OUT PLANS OR 19:26"
   V773 = "FINISH THINGS OR   19:27"
   V774 = "LIKE DIFF-CHALLENG 19:28"
   V775 = "RATHR SPND OR SAVE 19:29"
   V776 = "PREFER CHANCE RAISE19:30"
   V777 = "SATISFIED W SELF   19:31"
   V778 = "HAVE LIMITATIONS   19:32"
   V779 = "GET ANGRY EASILY   19:33"
   V780 = "MATTR OTHRS THINK  19:34"
   V781 = "TRUST MOST OTHERS  19:35"
   V782 = "FIGR WAYS MOR MONEY19:36"
   V783 = "THINK ABOUT FUTURE 19:37"
   V784 = "AV MAN GETTNG BETTR19:38"
   V785 = "LOT GOOD DONT DSRV 19:39"
   V786 = "HEAD-GREW UP FARM  19:40"
   V787 = "STATE H GREW UP19:41-42"
   V788 = "ST-CNTY GREW UP 19:41-45"
   V789 = "NR REGIONS LDV IN  19:46"
   V790 = "NR STATES H LVD IN 19:47"
   V791 = "SAME HEAD 68-69?   19:48"
   V792 = "HEADS PARENTS POOR 19:49"
   V793 = "HDS FATHERS EDUC   19:50"
   V794 = "EDUCATION OF HEAD  19:51"
   V795 = "OTHR TRAINING HEAD 19:52"
   V796 = "HEAD A VETERAN     19:53"
   V797 = "EVER MOVED FOR JOB 19:54"
   V798 = "EVER REFUSD MOVE   19:55"
   V799 = "WHO PRESENT        19:56"
   V800 = "WHO RESPONDENT(REL)19:57"
   V801 = "RACE               19:58"
   V802 = "NUMBER OF CALLS    19:59"
   V803 = "HOW CLEAN DU       19:60"
   V804 = "READING MTL VISIBLE19:61"
   V805 = "LANGUAGE PROBLEMS  19:62"
   V806 = "HEAD DISFIGURED    19:63"
   V807 = "IN CITY OF 5000+   19:64"
   V808 = "NEAREST SMSA    19:65-67"
   V809 = "DIST TO CNTR SMSA  19:68"
   V810 = "TYPE OF STRUCTURE  19:69"
   V811 = "NEIGHBORHOOD-LOWST 19:70"
   V812 = "NEIGHBORHOOD-HGHST 19:71"
   V813 = "DU IN PUB HOUSING  19:72"
   V814 = "INSIDE TOILET      19:73"
   V815 = "RUNNING WATER      19:74"
   V816 = "DU NEEDS EXTEN REP 19:75"
   V817 = "GEN OBSERV.-PROBS  19:76"
   V818 = "FLAKEY DATA IN INT 19:77"
   V819_1 = "2 WAYS 68/7 BTR 18:41-42 RESP 1"
   V819_2 = "2 WAYS 68/7 BTR 18:41-42 RESP 2"
   V820_1 = "2 REASONS OUTLK 18:45-46 RESP 1"
   V820_2 = "2 REASONS OUTLK 18:45-46 RESP 2"
   V821_1 = "TWO USES SP TIM 19:10-11 RESP 1"
   V821_2 = "TWO USES SP TIM 19:10-11 RESP 2"
   V822 = "YRLY PROP TAXES 9V382"
   V823 = "IMPUTED RENT 9V383"
   V824 = "HOUSE VALUE BKT 9V384"
   V825 = "LEISURE NET TRAVEL 9V385"
   V826 = "LEISURE COMP 68 9V386"
   V827 = "BKT TOT FU MON INC 9V387"
   V828 = "BKT LABOR INC HEAD 9V388"
   V829 = "BKT LABOR INC WIFE 9V389"
   V830 = "BKT H+W TAXABLE Y 9V390"
   V831 = "BKT OTHERS TAXBL Y 9V391"
   V832 = "BKT ADC 9V392"
   V833 = "BKT MISC TRANSFERS 9V393"
   V834 = "BKT OTHRS TRNSF Y 9V394"
   V835 = "MONEY Y/NEEDS 9V395"
   V836 = "BKT MONEY Y/NEEDS 9V396"
   V837 = "W-O MONEY 9V397"
   V838 = "BKT W-O MONEY 9V398"
   V839 = "FRE HELP FRM OTHRS 9V399"
   V840 = "TOTAL REAL Y 9V400"
   V841 = "BKT TOTAL REAL Y 9V401"
   V842 = "REAL NET Y 9V402"
   V843 = "BKT REAL NET Y 9V403"
   V844 = "REAL NET Y/NEEDS 9V404"
   V845 = "BKT RL NET Y/NEEDS 9V405"
   V846 = "W-O NET REAL 9V406"
   V847 = "BKT W-O NET REAL 9V407"
   V848 = "COST OF HOUSING 9V408"
   V849 = "BKT COST OF HOUSING 9V40"
   V850 = "REAL NET(2)Y 9V410"
   V851 = "BKT REAL NET(2) Y 9V411"
   V852 = "NET(2) Y/NEEDS 9V412"
   V853 = "BKT NET(2) Y/NEEDS 9V413"
   V854 = "W-O NET(2) Y 9V414"
   V855 = "BKT W-O NET(2)Y 9V415"
   V856 = "NET Y-HOUSING 9V416"
   V857 = "BKT NET Y-HOUSING 9V417"
   V858 = "NET Y-HSNG/FD ND 9V418"
   V859 = "BKT Y-HSNG/FD ND 9V19"
   V860 = "W-O NET Y-HSNG 9V420"
   V861 = "BKT W-O NET Y-HSNG 9V421"
   V862 = "W-O NET(2) Y-HSNG 9V422"
   V863 = "TOTAL FOOD CONS 9V423"
   V864 = "BKT FOOD CONSMPTN 9V424"
   V865 = "FOOD CONS/FD ND 9V425"
   V866 = "BKT FOOD/FD ND 9V426"
   V867 = "TOTAL FAMILY WORK 9V427"
   V868 = "BKT TOT FAM WORK 9V428"
   V869 = "FAM WORK INCL TRAV 9V429"
   V870 = "BKT WORK INCL TRAV 9V430"
   V871 = "HEADS HRLY EARN 9V431"
   V872 = "BKT HEAD HRLY EARN 9V432"
   V873 = "WIFES HRLY EARN 9V433"
   V874 = "BKT WIFE HRLY EARN 9V434"
   V875 = "RESERVE FUNDS 9V435"
   V876 = "CURRENT REGION 9V436"
   V877 = "REGION GREW UP 9V437"
   V878 = "GEOGRAPHCL MOBILITY 9V43"
   V879 = "ACCURACY MONEY INC 9V439"
   V880 = "ACCURACY HOURS 9V440"
   V881 = "ACCURACY REAL INC 9V441"
   V882 = "# MINOR ASSIGNMTS 9V442"
   V883 = "#MAJOR ASSIGNMTS 9V443"
   V884 = "VALUE PER ROOM 9V444"
   V885 = "BKT VALUE/ROOM 9V445"
   V886 = "BKT CAR VALUE 9V446"
   V887 = "BKT EARN ELSEWHERE 9V447"
   V888 = "BKT PAY REFUSED 9V448"
   V889 = "BKT PAY 2ND JOB 9V449"
   V890 = "BKT MARGINAL WAGE 9V450"
   V891 = "ACTUAL-REQD ROOMS 9V451"
   V892 = "PERSONS PER ROOM 9V452"
   V893 = "BKT PERSONS/RM 9V453"
   V894 = "NUMBER OF ADULTS 9V454"
   V895 = "HOUSEWORK H+W 9V455"
   V896 = "HOUSING NBRHD QUAL 9V456"
   V897 = "EFFICACY + PLANNING 9V45"
   V898 = "TRUST OR HOSTILITY 9V458"
   V899 = "SCRAMBLE FOR WORK 9V459"
   V900 = "ASPIRATION AMBITN 9V460"
   V901 = "REAL EARNING ACTS 9V461"
   V902 = "ECONOMIZING 9V462"
   V903 = "RISK AVOIDANCE 9V463"
   V904 = "HORIZON PROXIES 9V464"
   V905 = "CONNECTEDNESS 9V465"
   V906 = "MONEY EARNING ACTS 9V466"
   V907 = "UNREVISED V24  9V467"
   V908 = "UNREVISED V51  9V468"
   V909 = "SPLITOFF INDICATOR"
   V910 = "CHNG HDS LBR Y 9V910"
   V911 = "P CHNG HDS LBR Y 9V911"
   V912 = "BKT CHNG HDS LBR Y 9V912"
   V913 = "BT P CHG HDS LBR Y 9V913"
   V914 = "CHNG WIFES LBR Y 9V914"
   V915 = "CHNG TAXABLE Y H+W 9V915"
   V916 = "P CHNG TXBL Y H+W 9V916"
   V917 = "CHNG OTHERS TXBL Y 9V917"
   V918 = "CHNG FAM TRNSFRY 9V918"
   V919 = "CHG FAM MONEY 9V919"
   V920 = "P CHNG FAM MONEY Y 9V920"
   V921 = "BKT CHNG FAM MON Y 9V921"
   V922 = "BKT P CG FAM MON Y 9V922"
   V923 = "CHNG MONEY Y/NDS 9V923"
   V924 = "P CHNG MONEY Y/NDS 9V924"
   V925 = "BKT CHNG MON Y/NDS 9V925"
   V926 = "BT P CG MON Y/NDS 9V926"
   V927 = "CHNG W-O MONEY 9V927"
   V928 = "P CHNG W-O MONEY 9V928"
   V929 = "BKT CHNG W-O MONEY 9V929"
   V930 = "BKT P CG W-O MONEY 9V930"
   V931 = "CHNG NON-MONEY Y 9V931"
   V932 = "CHNG NET REAL Y 9V932"
   V933 = "PCHNG NET REAL Y 9V933"
   V934 = "CHNG NET RL Y/NDS 9V934"
   V935 = "P CG NET RL Y/NDS 9V935"
   V936 = "CHNG W-O NET RL Y 9V936"
   V937 = "P CG W-O NET RL Y 9V937"
   V938 = "CHNG NET RL Y-HSNG 9V938"
   V939 = "P CHG NET RL-HSNG 9V939"
   V940 = "CHNG W-O NET HSNG 9V940"
   V941 = "P CG W-O NET HSNG 9V941"
   V942 = "CG HDS WRK HRS 9V942"
   V943 = "P CG HDS WRK HRS 9V943"
   V944 = "BT P CG HDS WK HRS 9V944"
   V945 = "CHG WIFES WRK HRS 9V945"
   V946 = "CHG HOUSEWRK H+W 9V946"
   V947 = "CHG HOME PRODN HRS 9V947"
   V948 = "CHG OTHERS WRK HRS 9V948"
   V949 = "CHG TOT FAM HRS 9V949"
   V950 = "CHG TOT NONLSR 9V950"
   V951 = "CHG LEISURE/MAJ AD 9V951"
   V952 = "P CHG LEISR/MAJ AD 9V952"
   V953 = "CHNG HDS HRLY EARN 9V953"
   V954 = "PCG HDS HRLY ERN 9V954"
   V955 = "BKT P CHG HDS WAGE 9V955"
   V956 = "CHG WIFS HRLY EARN 9V956"
   V957 = "CHNG FOOD ND STD 9V957"
   V958 = "P CHNG FOOD ND STD 9V958"
   V959 = "CHG FU NEED STD 9V959"
   V960 = "CHG FU FOOD CONS 9V960"
   V961 = "P CHG FU FOOD CONS 9V961"
   V962 = "CHG FOOD CONS/NDS 9V962"
   V963 = "PCG FOOD CONS/NDS 9V963"
   V964 = "CHG ALCOHOL EXP 9V964"
   V965 = "CHG CIGRT EXP 9V965"
   V966 = "CHG HORIZN PROXIES 9V966"
   V967 = "CHG CONNECTEDNESS 9V967"
   V968 = "CHG MON EARNG ACTS 9V968"
   V969 = "CHG HSNG NBRHD QUAL V969"
   V970 = "CHG EFFICACY+PLNNG 9V970"
   V971 = "CHG TRUST-HOSTILTY 9V971"
   V972 = "CHG ASPIRATN AMBITN V972"
   V973 = "CHG RL EARNG ACTS 9V973"
   V974 = "CHG ECONOMIZING 9V974"
   V975 = "CHG RISK AVOIDANCE 9V975"
   V976 = "CHG NUMBER IN FU 9V976"
   V977 = "CHG JOB OR OCCUP 9V977"
   V978 = "CHG EARNERS RCVRS 9V978"
   V979 = "GEOG MOBLTY 1 YEAR 9V979"
   V980 = "MOVED WITHIN COUNTY 9V98"
   V981 = "MOVED BET COUNTIES 9V981"
   V982 = "MOVED BET STATES 9V982"
   V983 = "MOVED/NOT MOVED 9V983"
   V984 = "BKT CHG H.WAGE 9V984"
   V985 = "BKT CHG H HRS 9V985"
   V986 = "BKT CHG W WAGE 9V986"
   V987 = "BKT CHG W HRS 9V987"
   V988 = "BT HEAD 68 OCCUP 9V988"
   V989 = "CG NT-HSNG/FD ND 9V989"
   V990 = "DEC MONEY Y 9V471"
   V991 = "DEC ORSHAN:MONEY 9V472"
   V992 = "DEC W-O:MONEY 9V473"
   V993 = "DEC REAL NET Y 9V474"
   V994 = "DEC ORSH:REAL NET 9V475"
   V995 = "DEC W-O:REAL NET 9V476"
   V996 = "DEC REAL NET |-HSNG9V477"
   V997 = "DEC ORS:REL NET-HSG9V478"
   V998 = "DEC WO:REL NET-HSG9V479"
   V999 = "68 DEC MONEY Y"
   V1000 = "68 DEC REAL NET Y"
   V1001 = "68 DEC REL NET Y-HOUSING"
   V1002 = "68 DEC ORSHANSKY: MONEY"
   V1003 = "68 DEC ORSH: REAL NET"
   V1004 = "68 DEC ORSH: REL NET HSG"
   V1005 = "68 DEC W-O: MONEY"
   V1006 = "68 DEC W-O: REAL NET"
   V1007 = "68 DEC W-O: REL NET-HSNG"
   V1008 = "AGE OF HEAD 9V1008"
   V1009 = "BKT AGE HEAD 9V1009"
   V1010 = "SEX OF HEAD 9V1010"
   V1011 = "AGE OF WIFE 9V1011"
   V1012 = "BKT AGE WIFE 9V1012"
   V1013 = "AGE YNGST CHLD 9V1013"
   V1014 = "1969 FAMILY WEIGHT"
   V1015 = "HOUSEHOLD ID # 69"
   V1016 = "FU PRIMACY WITHIN HU";

* USER-DEFINED MISSING VALUE RECODE TO SAS SYSMIS;

IF V493 GE 99 THEN V493=.;
IF V543 GE 9 THEN V543=.;
IF V544 GE 9 THEN V544=.;
IF V545 GE 9 THEN V545=.;
IF V546 GE 9 THEN V546=.;
IF V547 GE 9 THEN V547=.;
IF V548 GE 9 THEN V548=.;
IF V549 GE 99 THEN V549=.;
IF V550 GE 99 THEN V550=.;
IF V554 GE 999 THEN V554=.;
IF V555 GE 9 THEN V555=.;
IF V556 GE 9 THEN V556=.;
IF V557 GE 9 THEN V557=.;
IF V558 GE 9 THEN V558=.;
IF V559 GE 9 THEN V559=.;
IF V560 GE 9 THEN V560=.;
IF V561 GE 9 THEN V561=.;
IF V562 GE 99 THEN V562=.;
IF V563 GE 99 THEN V563=.;
IF V564 GE 99 THEN V564=.;
IF V565 GE 99 THEN V565=.;
IF V566 GE 9 THEN V566=.;
IF V567 GE 9 THEN V567=.;
IF V568 GE 9 THEN V568=.;
IF V576 GE 9 THEN V576=.;
IF V577 GE 9 THEN V577=.;
IF V578 GE 9 THEN V578=.;
IF V579 GE 9 THEN V579=.;
IF V580 GE 9 THEN V580=.;
IF V581 GE 9 THEN V581=.;
IF V582 GE 99 THEN V582=.;
IF V583 GE 9 THEN V583=.;
IF V584 GE 9 THEN V584=.;
IF V585 GE 9 THEN V585=.;
IF V586 GE 9 THEN V586=.;
IF V587 GE 9 THEN V587=.;
IF V588 GE 9 THEN V588=.;
IF V589 GE 9 THEN V589=.;
IF V590 GE 9 THEN V590=.;
IF V591 GE 9 THEN V591=.;
IF V592 GE 9 THEN V592=.;
IF V593 GE 9 THEN V593=.;
IF V594 GE 9 THEN V594=.;
IF V595 GE 9 THEN V595=.;
IF V596 GE 9 THEN V596=.;
IF V597 GE 9 THEN V597=.;
IF V598 GE 9 THEN V598=.;
IF V599 GE 9 THEN V599=.;
IF V600 GE 9 THEN V600=.;
IF V601 GE 9 THEN V601=.;
IF V602 GE 9 THEN V602=.;
IF V603 GE 9 THEN V603=.;
IF V604 GE 9 THEN V604=.;
IF V605 GE 9 THEN V605=.;
IF V606 GE 9 THEN V606=.;
IF V607 GE 9 THEN V607=.;
IF V608 GE 9 THEN V608=.;
IF V609 GE 9 THEN V609=.;
IF V610 GE 9 THEN V610=.;
IF V611 GE 9 THEN V611=.;
IF V612 GE 9 THEN V612=.;
IF V613 GE 9 THEN V613=.;
IF V614 GE 9 THEN V614=.;
IF V615 GE 9 THEN V615=.;
IF V616 GE 9 THEN V616=.;
IF V617 GE 9 THEN V617=.;
IF V618 GE 9 THEN V618=.;
IF V619 GE 9 THEN V619=.;
IF V620 GE 9 THEN V620=.;
IF V621 GE 9 THEN V621=.;
IF V622 GE 9 THEN V622=.;
IF V623 GE 9 THEN V623=.;
IF V624 GE 9 THEN V624=.;
IF V625 GE 9 THEN V625=.;
IF V626 GE 9 THEN V626=.;
IF V627 GE 9 THEN V627=.;
IF V628 GE 9 THEN V628=.;
IF V629 GE 9 THEN V629=.;
IF V630 GE 9 THEN V630=.;
IF V631 GE 9 THEN V631=.;
IF V632 GE 9 THEN V632=.;
IF V633 GE 9 THEN V633=.;
IF V634 GE 9 THEN V634=.;
IF V635 GE 9 THEN V635=.;
IF V636 GE 9 THEN V636=.;
IF V637 GE 9 THEN V637=.;
IF V638 GE 9 THEN V638=.;
IF V639 GE 9 THEN V639=.;
IF V640 GE 9 THEN V640=.;
IF V641 GE 9 THEN V641=.;
IF V642 GE 9 THEN V642=.;
IF V643 GE 9 THEN V643=.;
IF V644 GE 9 THEN V644=.;
IF V645 GE 9 THEN V645=.;
IF V646 GE 9 THEN V646=.;
IF V648 GE 9 THEN V648=.;
IF V649 GE 9 THEN V649=.;
IF V650 GE 9 THEN V650=.;
IF V651 GE 9 THEN V651=.;
IF V652 GE 9 THEN V652=.;
IF V653 GE 9 THEN V653=.;
IF V654 GE 9 THEN V654=.;
IF V655 GE 9 THEN V655=.;
IF V656 GE 9 THEN V656=.;
IF V657 GE 9 THEN V657=.;
IF V658 GE 9 THEN V658=.;
IF V659 GE 9 THEN V659=.;
IF V660 GE 9 THEN V660=.;
IF V661 GE 9 THEN V661=.;
IF V662 GE 9 THEN V662=.;
IF V664 GE 9 THEN V664=.;
IF V665 GE 9 THEN V665=.;
IF V666 GE 9 THEN V666=.;
IF V668 GE 9 THEN V668=.;
IF V669 GE 9 THEN V669=.;
IF V670 GE 9 THEN V670=.;
IF V671 GE 9 THEN V671=.;
IF V672 GE 9 THEN V672=.;
IF V673 GE 9 THEN V673=.;
IF V674 GE 99 THEN V674=.;
IF V675 GE 9 THEN V675=.;
IF V676 GE 9 THEN V676=.;
IF V677 GE 9 THEN V677=.;
IF V678 GE 9 THEN V678=.;
IF V679 GE 9 THEN V679=.;
IF V680 GE 9 THEN V680=.;
IF V681 GE 9 THEN V681=.;
IF V682 GE 999 THEN V682=.;
IF V683 GE 9 THEN V683=.;
IF V684 GE 9 THEN V684=.;
IF V685 GE 9 THEN V685=.;
IF V686 GE 9 THEN V686=.;
IF V687 GE 999 THEN V687=.;
IF V688 GE 9 THEN V688=.;
IF V689 GE 999 THEN V689=.;
IF V690 GE 9 THEN V690=.;
IF V691 GE 9 THEN V691=.;
IF V692 GE 9 THEN V692=.;
IF V693 GE 9 THEN V693=.;
IF V694 GE 9 THEN V694=.;
IF V695 GE 9 THEN V695=.;
IF V696 GE 9 THEN V696=.;
IF V697 GE 9 THEN V697=.;
IF V698 GE 9 THEN V698=.;
IF V699 GE 9 THEN V699=.;
IF V700 GE 9 THEN V700=.;
IF V701 GE 9 THEN V701=.;
IF V702 GE 9 THEN V702=.;
IF V703 GE 9 THEN V703=.;
IF V704 GE 9 THEN V704=.;
IF V705 GE 9 THEN V705=.;
IF V706 GE 9 THEN V706=.;
IF V707 GE 9 THEN V707=.;
IF V708 GE 9 THEN V708=.;
IF V709 GE 9 THEN V709=.;
IF V710 GE 9 THEN V710=.;
IF V711 GE 9 THEN V711=.;
IF V712 GE 9 THEN V712=.;
IF V713 GE 9 THEN V713=.;
IF V714 GE 9 THEN V714=.;
IF V715 GE 9 THEN V715=.;
IF V716 GE 9 THEN V716=.;
IF V717 GE 9 THEN V717=.;
IF V718 GE 9 THEN V718=.;
IF V719 GE 9 THEN V719=.;
IF V720 GE 9 THEN V720=.;
IF V721 GE 9 THEN V721=.;
IF V722 GE 9 THEN V722=.;
IF V723 GE 9 THEN V723=.;
IF V724 GE 9 THEN V724=.;
IF V725 GE 9 THEN V725=.;
IF V726 GE 9 THEN V726=.;
IF V727 GE 9 THEN V727=.;
IF V728 GE 9 THEN V728=.;
IF V729 GE 9 THEN V729=.;
IF V730 GE 9 THEN V730=.;
IF V731 GE 9 THEN V731=.;
IF V732 GE 9 THEN V732=.;
IF V733 GE 9 THEN V733=.;
IF V734 GE 9 THEN V734=.;
IF V735 GE 9 THEN V735=.;
IF V736 GE 9 THEN V736=.;
IF V737 GE 9 THEN V737=.;
IF V738 GE 9 THEN V738=.;
IF V739 GE 9 THEN V739=.;
IF V740 GE 9 THEN V740=.;
IF V741 GE 9 THEN V741=.;
IF V742 GE 9 THEN V742=.;
IF V743 GE 9 THEN V743=.;
IF V744 GE 9 THEN V744=.;
IF V745 GE 9 THEN V745=.;
IF V746 GE 9 THEN V746=.;
IF V747 GE 9 THEN V747=.;
IF V748 GE 9 THEN V748=.;
IF V749 GE 9 THEN V749=.;
IF V750 GE 9 THEN V750=.;
IF V751 GE 9 THEN V751=.;
IF V752 GE 9 THEN V752=.;
IF V753 GE 9 THEN V753=.;
IF V754 GE 9 THEN V754=.;
IF V755 GE 9 THEN V755=.;
IF V756 GE 9 THEN V756=.;
IF V757 GE 9 THEN V757=.;
IF V758 GE 9 THEN V758=.;
IF V759 GE 9 THEN V759=.;
IF V760 GE 9 THEN V760=.;
IF V761 GE 9 THEN V761=.;
IF V762 GE 9 THEN V762=.;
IF V763 GE 9 THEN V763=.;
IF V764 GE 9 THEN V764=.;
IF V765 GE 9 THEN V765=.;
IF V766 GE 9 THEN V766=.;
IF V767 GE 9 THEN V767=.;
IF V768 GE 9 THEN V768=.;
IF V769 GE 9 THEN V769=.;
IF V770 GE 9 THEN V770=.;
IF V771 GE 9 THEN V771=.;
IF V772 GE 9 THEN V772=.;
IF V773 GE 9 THEN V773=.;
IF V774 GE 9 THEN V774=.;
IF V775 GE 9 THEN V775=.;
IF V776 GE 9 THEN V776=.;
IF V777 GE 9 THEN V777=.;
IF V778 GE 9 THEN V778=.;
IF V779 GE 9 THEN V779=.;
IF V780 GE 9 THEN V780=.;
IF V781 GE 9 THEN V781=.;
IF V782 GE 9 THEN V782=.;
IF V783 GE 9 THEN V783=.;
IF V784 GE 9 THEN V784=.;
IF V785 GE 9 THEN V785=.;
IF V786 GE 9 THEN V786=.;
IF V787 GE 99 THEN V787=.;
IF V788 GE 9 THEN V788=.;
IF V789 GE 9 THEN V789=.;
IF V790 GE 9 THEN V790=.;
IF V791 GE 9 THEN V791=.;
IF V792 GE 9 THEN V792=.;
IF V793 GE 9 THEN V793=.;
IF V794 GE 9 THEN V794=.;
IF V795 GE 9 THEN V795=.;
IF V796 GE 9 THEN V796=.;
IF V797 GE 9 THEN V797=.;
IF V798 GE 9 THEN V798=.;
IF V799 GE 9 THEN V799=.;
IF V800 GE 9 THEN V800=.;
IF V801 GE 9 THEN V801=.;
IF V802 GE 9 THEN V802=.;
IF V803 GE 9 THEN V803=.;
IF V804 GE 9 THEN V804=.;
IF V805 GE 9 THEN V805=.;
IF V806 GE 9 THEN V806=.;
IF V807 GE 9 THEN V807=.;
IF V808 GE 9 THEN V808=.;
IF V809 GE 9 THEN V809=.;
IF V810 GE 9 THEN V810=.;
IF V811 GE 9 THEN V811=.;
IF V812 GE 9 THEN V812=.;
IF V813 GE 9 THEN V813=.;
IF V814 GE 9 THEN V814=.;
IF V815 GE 9 THEN V815=.;
IF V816 GE 9 THEN V816=.;
IF V817 GE 9 THEN V817=.;
IF V818 GE 9 THEN V818=.;
IF V819_1 GE 9 THEN V819_1=.;
IF V819_2 GE 9 THEN V819_2=.;
IF V820_1 GE 9 THEN V820_1=.;
IF V820_2 GE 9 THEN V820_2=.;
IF V821_1 GE 9 THEN V821_1=.;
IF V821_2 GE 9 THEN V821_2=.;
IF V875=9 THEN V875=.;
IF V876=9 THEN V876=.;
IF V877=9 THEN V877=.;
IF V878=9 THEN V878=.;
IF V884=99999 THEN V884=.;
IF V885=9 THEN V885=.;
IF V887=9 THEN V887=.;
IF V888=9 THEN V888=.;
IF V889 GE 9 THEN V889=.;
IF V890 GE 9 THEN V890=.;
IF V891=9 THEN V891=.;
IF V892=9.9 THEN V892=.;
IF V893=9 THEN V893=.;
IF V911=9999 THEN V911=.;
IF V912=9 THEN V912=.;
IF V916=9999 THEN V916=.;
IF V920=9999 THEN V920=.;
IF V921=9 THEN V921=.;
IF V924=9999 THEN V924=.;
IF V928=9999 THEN V928=.;
IF V929=9 THEN V929=.;
IF V933=9999 THEN V933=.;
IF V935=9999 THEN V935=.;
IF V937=9999 THEN V937=.;
IF V939=9999 THEN V939=.;
IF V941=9999 THEN V941=.;
IF V943=9999 THEN V943=.;
IF V953=99.99 THEN V953=.;
IF V977=1 THEN V977=.;
IF V979=3 THEN V979=.;

file rawdat lrecl=1043;
put    
v442
v449
v450
v455
v456
v460
v461
v465
v466
v475
v476
v495
v500
v501
v506
v507
v510
v511
v514
v515
v516
v517
v518
v520
v521
v527
v529
v542
v549
v553
v581
v593
v594
v603
v604
v607
v610
v611
v639
v641
v643
v651
v658
v659
v703
v719
v733
v743
v791
v794
v801
v876
v879
v1008
v1010
v1011
v1014
v30022
;

 proc means;
 run; 
